function ThemeFile( file )
	return THEME:GetPath(EC_GRAPHICS,'', file )
end

function ColCon(n1, n2, n3)
	return (n1/255),(n2/255),(n3/255),1
end

CaveStoryTextBank = {

	--[[
	
	USAGE
	(If Contained)

	FACE NUMBER, TEXT
		TIME VALUES

	Animation Format
	Maximum 3 Text tweens. No more is needed.
	If more are required, modify ANIM_TextBox.xml

	If a tween is not needed on a dialog, 
	not adding the tween will work too.

		Cut1 = Value;
		Time1 = Value;
		Cut2 = Value;
		Sleep1 = Value;

		Time2 = Value;
		Cut3 = Value;
		Sleep2 = Value;
		Cut4 = Value;

		Time3 = Value;
		Cut5 = Value;
		Sleep3 = Value;
		Cut6 = Value;

		-- If the need to send to a new text string is needed,
		-- Use these three commands.

		RequestForNewText = true/false;
		SleepTimeBeforeNewText = Value;
		NewTextName = Name;

		-- If you need to Broadcast a MessageCommand,
		-- Use these two commands.
		RequestMessage = true/false;
		NewMessageName = Name;

		-----------
		-----------
		-----------
		-----------

		Faces List:

		0 - Nothing 
			(Added for sprites to start at 1 so i don't get confused)

		Sue (Mimiga Form)
			1 - Happy
			2 - Neutral/Concerned
			3 - Excited/Happily Mad
			4 - Gasp/Taken

		Sue (Normal Form) - 27

		Balrog
			5 - Neutral
			14 - Happy
			23 - Gasp/Defeated

		Misery
			15 - Neutral
			16 - Happy
			26 - Mad

		Prof. Booster
			17 - Glasses Broken
			18 - Normal

		Curly
			19 - Happy
			20 - Sad/Dissapointed
			25 - Normal

		Toroko	
			6 - Normal
			8 - Mad/Taken
			11 - Possesed (With the Red Flower)

		King 
			7 - Face
		Jack 
			9 - Face
		Kazuma 
			10 - Face
		Igor 
			12 - Face
		Jenka 
			13 - Face
		Momorin 
			22 - Face
		Broken Robot 
			24 - Face
		Itoh 
			28 - Face
		The Doctor 
			21 - Face

	]]

	Intro = {
		Text1 = "Jose_Varela Presents",
		Text2 = "A theme for NotITG\nBased on a game by Studio Pixel",
	},

	UITextElements = {
		WarpRoom = { Text = "Select a location to start in."; Cut1 = 1; Time1 = 0.3; Cut2 = 0; RequestForNewText = false; RequestMessage = false;},
		Selection_LeftRight = { Text = "Use LEFT or RIGHT to move, press START to select."; Cut1 = 1; Time1 = 0.3; Cut2 = 0; RequestForNewText = false; RequestMessage = false;},
	},

	MapLocations = {
		
		ArthurHouse = {

			{ Text = "Return to Warp Selection";
			PositionX = SCREEN_CENTER_X-160; PositionY = SCREEN_CENTER_Y+5; DialogOffset_IsUp = true; DialogOffset = 25;  Object = "Quote/Quote.sprite"; ObjectZoom = 0.5; },

			{ Text = "Check Messages";
			PositionX = SCREEN_CENTER_X-100; PositionY = SCREEN_CENTER_Y+15; DialogOffset_IsUp = true; DialogOffset = 35; Object = "Quote/Quote.sprite"; ObjectZoom = 0.5; },

			{ Text = "Rest In Bed";
			PositionX = SCREEN_CENTER_X-60; PositionY = SCREEN_CENTER_Y-105; DialogOffset_IsUp = true; DialogOffset = 55; Object = "Quote/Quote.sprite"; ObjectZoom = 0.5; },

			{ Text = "Exit to Mimiga Town";
			PositionX = SCREEN_CENTER_X+226; PositionY = SCREEN_CENTER_Y+15; DialogOffset_IsUp = true; DialogOffset = 55; Object = "Quote/Quote.sprite"; ObjectZoom = 0.5; },

			{ Text = "Secret";
			PositionX = SCREEN_CENTER_X+257; PositionY = SCREEN_CENTER_Y+20; DialogOffset_IsUp = true; DialogOffset = 55; Object = "Quote/Quote.sprite"; ObjectZoom = 0.5; },
		},

		WarpScreen = {
		"Arthur's House",
		"GrassTown",
		"Sand Zone",
		"Labyrinth",
		"Plantation",
		},

	},

	NotAvailable = {

		NotThere = {

					FaceID = 20;
					Text = "I'm sorry but... there's no screen in here yet. The developer hasn't completed it... I'm super sorry.";

					-- ANIMATION TWEENS
					Cut1 = 1;		Time1 = 0.3;
					Cut2 = 0.83;	Sleep1 = 1;
					Time2 = 0.6;	Cut3 = 0;

					-- SWITCH TWEENS
					RequestForNewText = true;
					SleepTimeBeforeNewText = 4;
					NewTextName = "NotThere2";
				},

		NotThere2 = {

					FaceID = 20;
					Text = "You can press ESC or BACK to return to the intro screen... Or you can just stay.";

					-- ANIMATION TWEENS
					Cut1 = 1;		Time1 = 0.9;
					Cut2 = 0.3;		Sleep1 = 1;
					Time2 = 0.6;	Cut3 = 0;

					-- SWITCH TWEENS
					RequestForNewText = true;
					SleepTimeBeforeNewText = 4;
					NewTextName = "EmptyText";
				},

		EmptyText = {

					FaceID = 0;
					Text = "";

					-- ANIMATION TWEENS
					Cut1 = 0;

					-- SWITCH TWEENS
					RequestForNewText = false;
					RequestMessage = true;
					NewMessageName = "HideTextBox";
				},
	},

	DialogTest = {
		
		Text1 = { 	

					FaceID = 25;
					Text = "Oh... And now you're here.\n\nI honestly didn't expect that you would come.";

					-- ANIMATION TWEENS
					Cut1 = 1;		Time1 = 0.3;
					Cut2 = 0.63;	Sleep1 = 1.5;
					Time2 = 0.5;	Cut3 = 0;

					-- SWITCH TWEENS
					RequestForNewText = true;
					SleepTimeBeforeNewText = 4;
					NewTextName = "Text2";
				},

		Text2 = { 	

					FaceID = 19;
					Text = "Anyways, that's not the point that i'm trying to get to.";

					-- ANIMATION TWEENS
					Cut1 = 1;		Time1 = 0.5;
					Cut2 = 0;	Sleep1 = 0;

					-- SWITCH TWEENS
					RequestForNewText = true;
					SleepTimeBeforeNewText = 4;
					NewTextName = "Text3";
				},

		Text3 = { 	

					FaceID = 25;
					Text = "You see, this is a test screen, designed to test the dialog feature in the theme.\n Right now I'm talking to you.";

					-- ANIMATION TWEENS
					Cut1 = 1;		Time1 = 0.5;
					Cut2 = 0.27;	Sleep1 = 0.8;
					Time2 = 0.2;	Cut3 = 0;

					-- SWITCH TWEENS
					RequestForNewText = true;
					SleepTimeBeforeNewText = 2;
					NewTextName = "Text4";
				},

		Text4 = {

					FaceID = 25;
					Text = "And this is all running on the same screen! Now there's no need to change screens to toggle the next dialog!";

					-- ANIMATION TWEENS
					Cut1 = 1;		Time1 = 0.5;
					Cut2 = 0;	Sleep1 = 0;

					-- SWITCH TWEENS
					RequestForNewText = true;
					SleepTimeBeforeNewText = 3;
					NewTextName = "Text5";
				},

		Text5 = {

					FaceID = 19;
					Text = "Look! Even my face updates depending on the FaceID Value!";

					-- ANIMATION TWEENS
					Cut1 = 1;		Time1 = 0.5;
					Cut2 = 0;	Sleep1 = 0.4;

					-- SWITCH TWEENS
					RequestForNewText = true;
					SleepTimeBeforeNewText = 2;
					NewTextName = "Text6";
				},

		Text6 = {

					FaceID = 19;
					Text = "Also, take a look at the sky!\nThat sky is a single Image.";

					-- ANIMATION TWEENS
					Cut1 = 1;		Time1 = 0.5;
					Cut2 = 0;	Sleep1 = 0.4;

					-- SWITCH TWEENS
					RequestForNewText = true;
					SleepTimeBeforeNewText = 2;
					RequestMessage = true;
					NewMessageName = "TweenSky";
					NewTextName = "Text7";
				},

		Text7 = {

					--FaceID = 19;
					Text = "It's essencially a single Bitmap, but divided into 5 layers. This is in a way to recreate the technique in the game to animate the sky.";

					-- ANIMATION TWEENS
					Cut1 = 1;		Time1 = 0.5;
					Cut2 = 0;	Sleep1 = 0.4;

					-- SWITCH TWEENS
					RequestForNewText = true;
					SleepTimeBeforeNewText = 4;
					NewTextName = "Text8";
				},

		Text8 = {

					FaceID = 19;
					Text = "Initially i didn\'t knew how it was going to work, but hey, it actually works!";

					-- ANIMATION TWEENS
					Cut1 = 1;		Time1 = 0.5;
					Cut2 = 0;	Sleep1 = 0.4;

					-- SWITCH TWEENS
					RequestForNewText = false;
				},

	},



}